$(function() {
    moment.locale('es');
    ComboInsumoProducto(1);
    //listar();
    $('#informes').addClass("active");
    // $('#i-karval').addClass("active");

    $('#start').bootstrapMaterialDatePicker({
        format: 'DD-MM-YYYY',
        time: false,
        lang: 'es-do',
        cancelText: 'Cancelar',
        okText: 'Aceptar'
    });

    $('#end').bootstrapMaterialDatePicker({
        useCurrent: false,
        format: 'DD-MM-YYYY',
        time: false,
        lang: 'es-do',
        cancelText: 'Cancelar',
        okText: 'Aceptar'
    });

});

$('#start, #end, #id_ip').change( function() {
    listar();
});

$("#tipo_ip").change(function(){
    $('#id_ip').find('option').remove();
    $("#tipo_ip option:selected").each(function(){
    id_tipo_ins=$(this).val();
       $.post("inventario_ComboInsumoProducto",{id_tipo_ins: id_tipo_ins},function(data){
           $("#id_ip").html(data);
           $('#id_ip').selectpicker();
           $('#id_ip').selectpicker('refresh');
       });
    });
})

var ComboInsumoProducto = function(id_tipo_ins){
    $('#id_ip').find('option').remove();
    $.ajax({
        type: "POST",
        url: $('#url').val()+"informe/inventario_ComboInsumoProducto",
        data: {id_tipo_ins: id_tipo_ins},
        success: function (response) {
            $('#id_ip').html(response);
            $('#id_ip').selectpicker();
            $('#id_ip').selectpicker('refresh');
        },
        error: function () {
            $('#id_ip').html('There was an error!');
        }
    });
}


var listar = function () {
  // 1) Leer filtros
  var tipo_ip = $("#tipo_ip").val();
  var id_ip   = $("#id_ip").val();
  var ifecha  = $("#start").val();
  var ffecha  = $("#end").val();

  // Variables para acumular
  let stockAcumulado = 0;
  let costoUnitarioActual = 0;

  // 2) Inicializar DataTable
  $('#table').DataTable({
    destroy:    true,
    responsive: true,
    dom:        "tip",
    bSort:      false,
    pageLength: 50,
    processing: true,

    ajax: {
      method: "POST",
      url:    $('#url').val() + "informe/inventario_kardex_list",
      data:   { tipo_ip: tipo_ip, id_ip: id_ip, ifecha: ifecha, ffecha: ffecha },
      dataSrc: 'data',
      error: function (xhr, status, err) {
        console.error('DT ajax error:', status, err, xhr?.responseText);
      }
    },

    columns: [
      // Fecha de registro
      {
        data: "fecha_registro",
        defaultContent: null,
        render: function (val) {
          if (!val) return '-';
          return '<i class="ti-calendar"></i> ' +
                 moment(val).format('DD-MM-YYYY') +
                 '<br><span class="font-12"><i class="ti-time"></i> ' +
                 moment(val).format('h:mm A') +
                 '</span>';
        }
      },

      // Descripción / concepto
      {
        data: null,
        defaultContent: null,
        render: function (row) {
          const activo = (row.estado === 'activo' || row.estado === 'a');
          const label  = activo ? '' : '<span class="label label-danger">ANULADO</span>';
          const cls    = activo ? '' : 'text-danger';

          const esVenta = (row.tipo_kardex === 'venta' || row.tipo_kardex === 'salidas');
          const docTxt  = esVenta
            ? `${row.serie_documento || ''}-${row.numero_documento || ''}`
            : '-';

          const concepto = row.concepto || (esVenta ? 'SALIDA, POR VENTA.' : 'MOVIMIENTO');

          return `${concepto} ${label}<br><span class="font-12 ${cls}">${docTxt}</span>`;
        }
      },

      // Entrada: cantidad
      {
        data: "cantidad_entrada",
        className: "text-success text-left",
        defaultContent: 0,
        render: function (v, t, row) {
          const esIngreso = (row.tipo_kardex === 'ingresos' || row.tipo_kardex === 'entrada' || row.tipo_kardex === 'ajuste_entrada');
          const val = parseFloat(v || 0);
          return esIngreso && val !== 0 ? val : '-';
        }
      },

      // Entrada: costo unitario
      {
        data: "costo_unitario",
        defaultContent: 0,
        render: function (v, t, row) {
          const esIngreso = (row.tipo_kardex === 'ingresos' || row.tipo_kardex === 'entrada' || row.tipo_kardex === 'ajuste_entrada');
          const n = parseFloat(v || 0);
          
          // Actualizar el costo unitario actual cuando hay entradas
          if (esIngreso && n !== 0) {
            costoUnitarioActual = n;
          }
          
          return esIngreso && n !== 0 ? formatNumber(n) : '-';
        }
      },

      // Entrada: costo total
      {
        data: "costo_total",
        defaultContent: 0,
        render: function (v, t, row) {
          const esIngreso = (row.tipo_kardex === 'ingresos' || row.tipo_kardex === 'entrada' || row.tipo_kardex === 'ajuste_entrada');
          const n = parseFloat(v || 0);
          return esIngreso && n !== 0 ? formatNumber(n) : '-';
        }
      },

      // Salida: cantidad
      {
        data: "cantidad_salida",
        className: "text-danger text-left",
        defaultContent: 0,
        render: function (v, t, row) {
          const esVenta = (row.tipo_kardex === 'venta' || row.tipo_kardex === 'salidas' || row.tipo_kardex === 'ajuste_salida');
          const val = parseFloat(v || 0);
          return esVenta && val !== 0 ? val : '-';
        }
      },

      // Salida: costo unitario
      {
        data: "costo_unitario",
        defaultContent: 0,
        render: function (v, t, row) {
          const esVenta = (row.tipo_kardex === 'venta' || row.tipo_kardex === 'salidas' || row.tipo_kardex === 'ajuste_salida');
          const n = parseFloat(v || 0);
          return esVenta && n !== 0 ? formatNumber(n) : '-';
        }
      },

      // Salida: costo total
      {
        data: "costo_total",
        defaultContent: 0,
        render: function (v, t, row) {
          const esVenta = (row.tipo_kardex === 'venta' || row.tipo_kardex === 'salidas' || row.tipo_kardex === 'ajuste_salida');
          const n = parseFloat(v || 0);
          return esVenta && n !== 0 ? formatNumber(n) : '-';
        }
      },

      // 🔥 **STOCK ACUMULADO**
      {
        data: "stock",
        defaultContent: 0,
        render: function (v, t, row) {
          
          const n = parseFloat(v || 0);
          return  formatNumber(n);
        }
      },

      // 🔥 **COSTO UNITARIO GENERAL (actualizado)**
      {
        data: "costo_unitario",
        defaultContent: 0,
        render: function (v, t, row) {
          const n = parseFloat(v || 0);
          // Actualizar costo unitario actual si este registro tiene un costo válido
          if (n !== 0 && !isNaN(n)) {
            costoUnitarioActual = n;
          }
          return n ? formatNumber(n) : formatNumber(costoUnitarioActual);
        }
      },

      // 🔥 **COSTO TOTAL - MODIFICADO (stock acumulado * costo unitario)**
      {
        data: null,
        defaultContent: 0,
        render: function (val, type, row, meta) {
          // Calcular costo total = stock acumulado * costo unitario actual
          const costoTotal = stockAcumulado * costoUnitarioActual;
          
          return '<div class="font-medium text-center">' + 
                 formatNumber(costoTotal) + 
                 '</div>';
        }
      }
    ],

    footerCallback: function (row, data) {
      // Reiniciar acumuladores para los cálculos del footer
      let stock_inicial = 0;
      let stock_entradas = 0;
      let stock_salidas = 0;
      
      // Si hay datos, tomar el stock inicial del primer registro
      if (data.length > 0) {
        stock_inicial = parseFloat(data[0].stock_inicial || 0);
      }

      data.forEach(item => {
        stock_entradas += parseFloat(item.cantidad_entrada || 0);
        stock_salidas  += parseFloat(item.cantidad_salida  || 0);
      });

      let stock_final = stock_inicial + stock_entradas - stock_salidas;

      $('.stock-inicial').html(stock_inicial.toFixed(4));
      $('.stock-entradas').html(stock_entradas.toFixed(4));
      $('.stock-salidas').html(stock_salidas.toFixed(4));
      $('.stock-final').html(stock_final.toFixed(4));
    }
  });
};

// var listar = function () {
//   // 1) Leer filtros
//   var tipo_ip = $("#tipo_ip").val();
//   var id_ip   = $("#id_ip").val();
//   var ifecha  = $("#start").val();
//   var ffecha  = $("#end").val();

//   // Variables para acumular
//   let stockAcumulado = 0;
//   let costoUnitarioActual = 0;
  
//   // 🔥 NUEVA: Variable para suma total de entradas
//   let totalEntradas = 0;

//   // 2) Inicializar DataTable
//   $('#table').DataTable({
//     destroy:    true,
//     responsive: true,
//     dom:        "tip",
//     bSort:      false,
//     pageLength: 50,
//     processing: true,

//     ajax: {
//       method: "POST",
//       url:    $('#url').val() + "informe/inventario_kardex_list",
//       data:   { tipo_ip: tipo_ip, id_ip: id_ip, ifecha: ifecha, ffecha: ffecha },
//       dataSrc: function (json) {
//         // 🔥 PRE-CALCULAR la suma total de entradas
//         totalEntradas = 0;
        
//         if (json.data && json.data.length > 0) {
//           json.data.forEach(function(item) {
//             const entrada = parseFloat(item.cantidad_entrada || 0);
//             totalEntradas += entrada;
//           });
          
//           console.log("Total de entradas calculado:", totalEntradas);
//         }
        
//         return json.data;
//       },
//       error: function (xhr, status, err) {
//         console.error('DT ajax error:', status, err, xhr?.responseText);
//       }
//     },

//     columns: [
//       // Fecha de registro
//       {
//         data: "fecha_registro",
//         defaultContent: null,
//         render: function (val) {
//           if (!val) return '-';
//           return '<i class="ti-calendar"></i> ' +
//                  moment(val).format('DD-MM-YYYY') +
//                  '<br><span class="font-12"><i class="ti-time"></i> ' +
//                  moment(val).format('h:mm A') +
//                  '</span>';
//         }
//       },

//       // Descripción / concepto
//       {
//         data: null,
//         defaultContent: null,
//         render: function (row) {
//           const activo = (row.estado === 'activo' || row.estado === 'a');
//           const label  = activo ? '' : '<span class="label label-danger">ANULADO</span>';
//           const cls    = activo ? '' : 'text-danger';

//           const esVenta = (row.tipo_kardex === 'venta' || row.tipo_kardex === 'salidas');
//           const docTxt  = esVenta
//             ? `${row.serie_documento || ''}-${row.numero_documento || ''}`
//             : '-';

//           const concepto = row.concepto || (esVenta ? 'SALIDA, POR VENTA.' : 'MOVIMIENTO');

//           return `${concepto} ${label}<br><span class="font-12 ${cls}">${docTxt}</span>`;
//         }
//       },

//       // Entrada: cantidad
//       {
//         data: "cantidad_entrada",
//         className: "text-success text-left",
//         defaultContent: 0,
//         render: function (v, t, row) {
//           const esIngreso = (row.tipo_kardex === 'ingresos' || row.tipo_kardex === 'entrada' || row.tipo_kardex === 'ajuste_entrada');
//           const val = parseFloat(v || 0);
//           return esIngreso && val !== 0 ? val : '-';
//         }
//       },

//       // Entrada: costo unitario
//       {
//         data: "costo_unitario",
//         defaultContent: 0,
//         render: function (v, t, row) {
//           const esIngreso = (row.tipo_kardex === 'ingresos' || row.tipo_kardex === 'entrada' || row.tipo_kardex === 'ajuste_entrada');
//           const n = parseFloat(v || 0);
          
//           // Actualizar el costo unitario actual cuando hay entradas
//           if (esIngreso && n !== 0) {
//             costoUnitarioActual = n;
//           }
          
//           return esIngreso && n !== 0 ? formatNumber(n) : '-';
//         }
//       },

//       // Entrada: costo total
//       {
//         data: "costo_total",
//         defaultContent: 0,
//         render: function (v, t, row) {
//           const esIngreso = (row.tipo_kardex === 'ingresos' || row.tipo_kardex === 'entrada' || row.tipo_kardex === 'ajuste_entrada');
//           const n = parseFloat(v || 0);
//           return esIngreso && n !== 0 ? formatNumber(n) : '-';
//         }
//       },

//       // Salida: cantidad
//       {
//         data: "cantidad_salida",
//         className: "text-danger text-left",
//         defaultContent: 0,
//         render: function (v, t, row) {
//           const esVenta = (row.tipo_kardex === 'venta' || row.tipo_kardex === 'salidas' || row.tipo_kardex === 'ajuste_salida');
//           const val = parseFloat(v || 0);
//           return esVenta && val !== 0 ? val : '-';
//         }
//       },

//       // Salida: costo unitario
//       {
//         data: "costo_unitario",
//         defaultContent: 0,
//         render: function (v, t, row) {
//           const esVenta = (row.tipo_kardex === 'venta' || row.tipo_kardex === 'salidas' || row.tipo_kardex === 'ajuste_salida');
//           const n = parseFloat(v || 0);
//           return esVenta && n !== 0 ? formatNumber(n) : '-';
//         }
//       },

//       // Salida: costo total
//       {
//         data: "costo_total",
//         defaultContent: 0,
//         render: function (v, t, row) {
//           const esVenta = (row.tipo_kardex === 'venta' || row.tipo_kardex === 'salidas' || row.tipo_kardex === 'ajuste_salida');
//           const n = parseFloat(v || 0);
//           return esVenta && n !== 0 ? formatNumber(n) : '-';
//         }
//       },

//       // 🔥 **STOCK ACUMULADO**
//       {
//         data: null,
//         defaultContent: 0,
//         render: function (val, type, row, meta) {
//           // Calcular el movimiento neto de esta fila
//           const entrada = parseFloat(row.cantidad_entrada || 0);
//           const salida = parseFloat(row.cantidad_salida || 0);
//           const movimientoNeto = entrada - salida;
          
//           // Si es la primera fila, inicializar con el stock inicial si existe
//           if (meta.row === 0) {
//             stockAcumulado = parseFloat(row.stock_inicial || 0);
//             // También inicializar el costo unitario si hay stock inicial
//             if (stockAcumulado > 0 && row.costo_unitario) {
//               costoUnitarioActual = parseFloat(row.costo_unitario || 0);
//             }
//           }
          
//           // Actualizar el stock acumulado
//           stockAcumulado += movimientoNeto;
//           //stockAcumulado = salida > 0 ? totalEntradas - stockAcumulado : stockAcumulado;
//           console.log(stockAcumulado);
          
          
//           // Formatear y mostrar
//           return `<div class="text-info text-center">${stockAcumulado.toFixed(4)}</div>`;
//         }
//       },

//       // 🔥 **COSTO UNITARIO GENERAL (actualizado)**
//       {
//         data: "costo_unitario",
//         defaultContent: 0,
//         render: function (v, t, row) {
//           const n = parseFloat(v || 0);
//           // Actualizar costo unitario actual si este registro tiene un costo válido
//           if (n !== 0 && !isNaN(n)) {
//             costoUnitarioActual = n;
//           }
//           return n ? formatNumber(n) : formatNumber(costoUnitarioActual);
//         }
//       },

//       // 🔥 **COSTO TOTAL - MODIFICADO (stock acumulado * costo unitario)**
//       {
//         data: null,
//         defaultContent: 0,
//         render: function (val, type, row, meta) {
//           // Calcular costo total = stock acumulado * costo unitario actual
//           const costoTotal = stockAcumulado * costoUnitarioActual;
          
//           return '<div class="font-medium text-center">' + 
//                  formatNumber(costoTotal) + 
//                  '</div>';
//         }
//       }
//     ],

//     footerCallback: function (row, data) {
//       // Reiniciar acumuladores para los cálculos del footer
//       let stock_inicial = 0;
//       let stock_entradas = 0;
//       let stock_salidas = 0;
      
//       // Si hay datos, tomar el stock inicial del primer registro
//       if (data.length > 0) {
//         stock_inicial = parseFloat(data[0].stock_inicial || 0);
//       }

//       data.forEach(item => {
//         stock_entradas += parseFloat(item.cantidad_entrada || 0);
//         stock_salidas  += parseFloat(item.cantidad_salida  || 0);
//       });

//       let stock_final = stock_inicial + stock_entradas - stock_salidas;

//       $('.stock-inicial').html(stock_inicial.toFixed(4));
//       $('.stock-entradas').html(stock_entradas.toFixed(4));
//       $('.stock-salidas').html(stock_salidas.toFixed(4));
//       $('.stock-final').html(stock_final.toFixed(4));
      
//       // 🔥 MOSTRAR EL TOTAL DE ENTRADAS CALCULADO
//       // console.log("Total de entradas (desde variable):", totalEntradas);
//       // console.log("Total de entradas (desde footer):", stock_entradas);
      
//       // Si quieres mostrarlo en la UI también:
//       $('.total-entradas-global').html(totalEntradas.toFixed(4));
//     },

//     // 🔥 INIT COMPLETE para verificar los cálculos
//     initComplete: function(settings, json) {
//       //console.log("DataTable inicializado. Total entradas:", totalEntradas);
//     }
//   });
// };